<?php
/**
 * SuiteCRM is a customer relationship management program developed by SuiteCRM Ltd.
 * Copyright (C) 2025 SuiteCRM Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUITECRM, SUITECRM DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */

namespace App\Module\Campaigns\Service\Email\Targets;

use App\Data\LegacyHandler\PreparedStatementHandler;
use App\SystemConfig\LegacyHandler\SystemConfigHandler;
use Doctrine\DBAL\Exception;
use Psr\Log\LoggerInterface;

class DefaultEmailMarketingDuplicateChecker implements EmailMarketingDuplicateCheckerInterface
{
    public function __construct(
        protected PreparedStatementHandler $preparedStatementHandler,
        protected LoggerInterface $logger
    ) {
    }

    public function isDuplicateEmail(string $emailMarketingId, string $email): bool
    {

        $queryBuilder = $this->preparedStatementHandler->createQueryBuilder();

        $queryBuilder
            ->select('*')
            ->from('campaign_log')
            ->where('marketing_id = :mkt_id')
            ->andWhere('more_information = :email')
            ->andWhere('deleted = 0');
        $queryBuilder->setParameter('mkt_id', $emailMarketingId);
        $queryBuilder->setParameter('email', strtolower($email));
        $queryBuilder->setMaxResults(1);

        $results = [];
        try {
            $results = $queryBuilder->fetchAllAssociative();
        } catch (Exception $e) {
            $this->logger->error('DefaultEmailMarketingDuplicateChecker::isDuplicateEmail error in query  | email marketing id - ' . $emailMarketingId . ' | ' . $e->getMessage());
        }

        if (empty($results)) {
            return false;
        }

        return true;
    }
}
